package de.bebagoe.figuren;

public sealed class Rechteck extends Figur permits RechteckGS {
	protected double breite, hoehe;
	
	public Rechteck(double x, double y, double b, double h) {
        if (b < 0 || h < 0)
            throw new IllegalArgumentException("Flächeninhalt negativ");
        breite = b;
        hoehe = h;
		super(x, y);
	}

    public Rechteck(double b, double h) {
        if (b < 0 || h < 0)
            throw new IllegalArgumentException("Flächeninhalt negativ");
        breite = b;
        hoehe = h;
        super();
    }

	public Rechteck() {
        breite = 100.0;
        hoehe = 50.0;
        super();
    }

    public double getBreite() {
        return breite;
    }
    public double getHoehe() {
        return hoehe;
    }

    @Override
	public void wo() {
		super.wo();
		System.out.println("Unten rechts: (" + (xpos+breite) +
						", " + (ypos+hoehe) + ")");
	}

	@Override
	public double meldeInhalt() {
		return breite * hoehe;
	}

    @Override
    public double abstand(double x, double y) {
        return Math.sqrt(Math.pow(xpos+breite/2-x,2) + Math.pow(ypos+hoehe/2-y,2));
    }
}

